import turtle
turtle.tracer(10, 0) # Zwiększ wartość pierwszego argumentu, aby przyspieszyć rysowanie
turtle.setworldcoordinates(0, 0, 700, 700)
turtle.hideturtle()

LINE_LENGTH  = 5 # Spróbuj odrobinę zmienić długość linii
ANGLE = 90 # Spróbuj odrobinę zmienić kąt obrotu
LEVELS = 6 # Spróbuj odrobinę zmienić poziom rekurencji
DRAW_SOLID = False
#turtle.setheading(20) # Odkomentuj, aby narysować krzywe pod kątem

def hilbertCurveQuadrant(level, angle):
    if level == 0:
        # PRZYPADEK BAZOWY
        return
    else:
        # PRZYPADEK REKURENCYJNY
        turtle.right(angle)
        hilbertCurveQuadrant(level - 1, -angle)
        turtle.forward(LINE_LENGTH)
        turtle.left(angle)
        hilbertCurveQuadrant(level - 1, angle)
        turtle.forward(LINE_LENGTH)
        hilbertCurveQuadrant(level - 1, angle)
        turtle.left(angle)
        turtle.forward(LINE_LENGTH)
        hilbertCurveQuadrant(level - 1, -angle)
        turtle.right(angle)
        return

def hilbertCurve(startingPosition):
    # Przesunięcie żółwia do punktu startowego
    turtle.penup()
    turtle.goto(startingPosition)
    turtle.pendown()
    if DRAW_SOLID:
        turtle.begin_fill()

    hilbertCurveQuadrant(LEVELS, ANGLE) # Rysowanie lewej dolnej ćwiartki
    turtle.forward(LINE_LENGTH)

    hilbertCurveQuadrant(LEVELS, ANGLE) # Rysowanie prawej dolnej ćwiartki
    turtle.left(ANGLE)
    turtle.forward(LINE_LENGTH)
    turtle.left(ANGLE)

    hilbertCurveQuadrant(LEVELS, ANGLE) # Rysowanie prawej górnej ćwiartki
    turtle.forward(LINE_LENGTH)

    hilbertCurveQuadrant(LEVELS, ANGLE) # Rysowanie prawej dolnej ćwiartki

    turtle.left(ANGLE)
    turtle.forward(LINE_LENGTH)
    turtle.left(ANGLE)
    if DRAW_SOLID:
        turtle.end_fill()

hilbertCurve((30, 350))
turtle.exitonclick()
